﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Net;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using Microsoft.VisualBasic.CompilerServices;

namespace Darkminer_v6
{
	// Token: 0x02000023 RID: 35
	[DesignerGenerated]
	public partial class Form14 : Form
	{
		// Token: 0x0600013F RID: 319 RVA: 0x0000BDB0 File Offset: 0x00009FB0
		public Form14()
		{
			base.Load += this.Form14_Load;
			this.cancellationTokenSource = new CancellationTokenSource();
			this.random = new Random();
			this.tries = 0;
			this.isMining = false;
			this.foundCount = 0;
			this.words = new string[]
			{
				"person",
				"offer",
				"year",
				"chain",
				"road",
				"head",
				"content",
				"work",
				"world",
				"flat",
				"code",
				"law",
				"source",
				"table",
				"parrot",
				"key",
				"deep",
				"family",
				"luck",
				"gold",
				"thing",
				"picture",
				"island",
				"foot",
				"spring",
				"object",
				"oak",
				"squirrel",
				"peace",
				"orange",
				"windmill",
				"side",
				"star",
				"sun",
				"tree",
				"water",
				"apple",
				"book",
				"chair",
				"dog",
				"elephant",
				"flower",
				"guitar",
				"hat",
				"ice cream",
				"jelly",
				"table",
				"lamp",
				"computer",
				"shoe",
				"keyboard",
				"candle",
				"window",
				"car",
				"bicycle",
				"phone",
				"pencil",
				"pen",
				"globe",
				"clock",
				"mirror",
				"television",
				"camera",
				"pillow",
				"blanket",
				"guitar",
				"keyboard",
				"flower",
				"lamp",
				"couch",
				"window",
				"door",
				"table",
				"coffee",
				"mug",
				"cookie",
				"cake",
				"candy",
				"jacket",
				"hat",
				"scarf",
				"gloves",
				"umbrella",
				"rain",
				"sun",
				"moon",
				"star",
				"cloud",
				"tree",
				"river",
				"mountain",
				"beach",
				"ocean",
				"lake",
				"forest",
				"desert",
				"island",
				"ship",
				"airplane",
				"train",
				"bus",
				"subway",
				"taxi",
				"hotel",
				"restaurant",
				"library",
				"school",
				"university",
				"hospital",
				"doctor",
				"nurse",
				"police",
				"firefighter",
				"teacher",
				"student",
				"artist",
				"musician",
				"actor",
				"director",
				"writer",
				"dancer",
				"chef",
				"scientist",
				"engineer",
				"programmer",
				"designer",
				"athlete",
				"singer",
				"athlete",
				"politician",
				"lawyer",
				"judge",
				"journalist",
				"photographer",
				"veterinarian",
				"architect"
			};
			this.textBuilder = new StringBuilder();
			this.InitializeComponent();
		}

		// Token: 0x17000063 RID: 99
		// (get) Token: 0x06000142 RID: 322 RVA: 0x00002CBA File Offset: 0x00000EBA
		// (set) Token: 0x06000143 RID: 323 RVA: 0x0000CB70 File Offset: 0x0000AD70
		internal virtual Button StartButton
		{
			[CompilerGenerated]
			get
			{
				return this._StartButton;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.StartButton_Click);
				Button startButton = this._StartButton;
				if (startButton != null)
				{
					startButton.Click -= value2;
				}
				this._StartButton = value;
				startButton = this._StartButton;
				if (startButton != null)
				{
					startButton.Click += value2;
				}
			}
		}

		// Token: 0x17000064 RID: 100
		// (get) Token: 0x06000144 RID: 324 RVA: 0x00002CC4 File Offset: 0x00000EC4
		// (set) Token: 0x06000145 RID: 325 RVA: 0x0000CBB4 File Offset: 0x0000ADB4
		internal virtual Button StopButton
		{
			[CompilerGenerated]
			get
			{
				return this._StopButton;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.StopButton_Click);
				Button stopButton = this._StopButton;
				if (stopButton != null)
				{
					stopButton.Click -= value2;
				}
				this._StopButton = value;
				stopButton = this._StopButton;
				if (stopButton != null)
				{
					stopButton.Click += value2;
				}
			}
		}

		// Token: 0x17000065 RID: 101
		// (get) Token: 0x06000146 RID: 326 RVA: 0x00002CCE File Offset: 0x00000ECE
		// (set) Token: 0x06000147 RID: 327 RVA: 0x00002CD8 File Offset: 0x00000ED8
		internal virtual RichTextBox ResultRichTextBox { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000066 RID: 102
		// (get) Token: 0x06000148 RID: 328 RVA: 0x00002CE1 File Offset: 0x00000EE1
		// (set) Token: 0x06000149 RID: 329 RVA: 0x00002CEB File Offset: 0x00000EEB
		internal virtual CheckBox EthCheckBox { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000067 RID: 103
		// (get) Token: 0x0600014A RID: 330 RVA: 0x00002CF4 File Offset: 0x00000EF4
		// (set) Token: 0x0600014B RID: 331 RVA: 0x00002CFE File Offset: 0x00000EFE
		internal virtual Label RecordCountLabel { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000068 RID: 104
		// (get) Token: 0x0600014C RID: 332 RVA: 0x00002D07 File Offset: 0x00000F07
		// (set) Token: 0x0600014D RID: 333 RVA: 0x00002D11 File Offset: 0x00000F11
		internal virtual RichTextBox Izpis { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000069 RID: 105
		// (get) Token: 0x0600014E RID: 334 RVA: 0x00002D1A File Offset: 0x00000F1A
		// (set) Token: 0x0600014F RID: 335 RVA: 0x00002D24 File Offset: 0x00000F24
		internal virtual Label Found { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x1700006A RID: 106
		// (get) Token: 0x06000150 RID: 336 RVA: 0x00002D2D File Offset: 0x00000F2D
		// (set) Token: 0x06000151 RID: 337 RVA: 0x00002D37 File Offset: 0x00000F37
		internal virtual PictureBox PictureBox1 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x1700006B RID: 107
		// (get) Token: 0x06000152 RID: 338 RVA: 0x00002D40 File Offset: 0x00000F40
		// (set) Token: 0x06000153 RID: 339 RVA: 0x00002D4A File Offset: 0x00000F4A
		internal virtual PictureBox PictureBox2 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x1700006C RID: 108
		// (get) Token: 0x06000154 RID: 340 RVA: 0x00002D53 File Offset: 0x00000F53
		// (set) Token: 0x06000155 RID: 341 RVA: 0x00002D5D File Offset: 0x00000F5D
		internal virtual CheckBox CheckBox1 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x1700006D RID: 109
		// (get) Token: 0x06000156 RID: 342 RVA: 0x00002D66 File Offset: 0x00000F66
		// (set) Token: 0x06000157 RID: 343 RVA: 0x00002D70 File Offset: 0x00000F70
		private virtual System.Windows.Forms.Timer timer { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x06000158 RID: 344 RVA: 0x0000CBF8 File Offset: 0x0000ADF8
		private void Form14_Load(object sender, EventArgs e)
		{
			this.ResultRichTextBox.ReadOnly = true;
			this.ResultRichTextBox.BackColor = Color.Black;
			this.ResultRichTextBox.Font = new Font(SystemFonts.DefaultFont.FontFamily, 12f);
			this.ResultRichTextBox.WordWrap = false;
			System.Windows.Forms.Timer timer = new System.Windows.Forms.Timer();
			timer.Tick += this.InternetCheckTimer_Tick;
			timer.Interval = 5000;
			timer.Start();
		}

		// Token: 0x06000159 RID: 345 RVA: 0x0000CC80 File Offset: 0x0000AE80
		private void InternetCheckTimer_Tick(object sender, EventArgs e)
		{
			bool flag = this.CheckForInternetConnection();
			bool flag2 = !flag;
			if (flag2)
			{
				this.StopMining();
			}
		}

		// Token: 0x0600015A RID: 346 RVA: 0x0000CCA8 File Offset: 0x0000AEA8
		private void StopMining()
		{
			bool flag = this.isMining;
			if (flag)
			{
				this.cancellationTokenSource.Cancel();
				try
				{
					this.cancellationTokenSource.Token.ThrowIfCancellationRequested();
				}
				catch (OperationCanceledException ex)
				{
				}
				this.isMining = false;
				Application.Exit();
			}
		}

		// Token: 0x0600015B RID: 347 RVA: 0x0000CD14 File Offset: 0x0000AF14
		private void AppendTextWithScroll(string text, Color color, bool isBold, float fontSize)
		{
			bool invokeRequired = this.ResultRichTextBox.InvokeRequired;
			if (invokeRequired)
			{
				this.ResultRichTextBox.Invoke(delegate()
				{
					this.AppendTextWithScroll(text, color, isBold, fontSize);
				});
			}
			else
			{
				this.ResultRichTextBox.SelectionColor = color;
				bool $VB$Local_isBold = isBold;
				if ($VB$Local_isBold)
				{
					this.ResultRichTextBox.SelectionFont = new Font(this.ResultRichTextBox.Font.FontFamily, fontSize, FontStyle.Bold);
				}
				else
				{
					this.ResultRichTextBox.SelectionFont = new Font(this.ResultRichTextBox.Font.FontFamily, fontSize, FontStyle.Regular);
				}
				this.textBuilder.Append(text + " ");
				bool flag = text.EndsWith("\r\n");
				if (flag)
				{
					this.ResultRichTextBox.AppendText(this.textBuilder.ToString().TrimEnd() + Environment.NewLine);
					this.ResultRichTextBox.ScrollToCaret();
					this.textBuilder.Clear();
				}
				this.UpdateRecordCountLabel();
			}
		}

		// Token: 0x0600015C RID: 348 RVA: 0x00004E60 File Offset: 0x00003060
		private bool CheckForInternetConnection()
		{
			bool result;
			try
			{
				WebRequest webRequest = WebRequest.Create("http://www.google.com");
				WebResponse response = webRequest.GetResponse();
				result = true;
			}
			catch (Exception ex)
			{
				result = false;
			}
			return result;
		}

		// Token: 0x0600015D RID: 349 RVA: 0x00002D79 File Offset: 0x00000F79
		private void UpdateRecordCountLabel()
		{
			this.RecordCountLabel.Text = string.Format("Checked: {0}", this.ResultRichTextBox.Lines.Length);
		}

		// Token: 0x0600015E RID: 350 RVA: 0x0000CE64 File Offset: 0x0000B064
		private async void StartButton_Click(object sender, EventArgs e)
		{
			Form14._Closure$__61-0 CS$<>8__locals1 = new Form14._Closure$__61-0(CS$<>8__locals1);
			CS$<>8__locals1.$VB$Me = this;
			bool flag = this.isMining;
			if (!flag)
			{
				CS$<>8__locals1.$VB$Local_selectedCrypto = "";
				bool validCrypto = false;
				bool flag2 = Operators.CompareString(CS$<>8__locals1.$VB$Local_selectedCrypto, "ETH", false) == 0 || Operators.CompareString(CS$<>8__locals1.$VB$Local_selectedCrypto, "BTC", false) == 0;
				if (flag2)
				{
					validCrypto = true;
					this.isMining = true;
					this.AppendTextWithScroll("Wallet check:   luck foot star sun flat person sun content tree parrot luck offer", Color.Green, true, 16f);
					await Task.Run(checked(delegate()
					{
						int num = 0;
						while (!CS$<>8__locals1.$VB$Me.cancellationTokenSource.Token.IsCancellationRequested)
						{
							bool flag3 = CS$<>8__locals1.$VB$Me.tries > CS$<>8__locals1.$VB$Me.random.Next(1500, 1000000000);
							if (flag3)
							{
								string text = Form14.id_gen(38, "AbCdEfGhIjkLMnOpQrStUvWxYz0123456789");
								bool flag4 = Operators.CompareString(CS$<>8__locals1.$VB$Local_selectedCrypto, "ETH", false) == 0;
								List<string> list;
								int num3;
								unchecked
								{
									if (flag4)
									{
										double num2 = Math.Round(CS$<>8__locals1.$VB$Me.random.NextDouble() * 2.9 + 0.1, 4);
									}
									else
									{
										bool flag5 = Operators.CompareString(CS$<>8__locals1.$VB$Local_selectedCrypto, "BTC", false) == 0;
										if (flag5)
										{
											double num2 = Math.Round(CS$<>8__locals1.$VB$Me.random.NextDouble() * 0.99 + 0.01, 4);
										}
									}
									list = new List<string>();
									num3 = 0;
								}
								do
								{
									bool flag6 = num3 < CS$<>8__locals1.$VB$Me.words.Length;
									if (flag6)
									{
										list.Add(CS$<>8__locals1.$VB$Me.words[CS$<>8__locals1.$VB$Me.random.Next(CS$<>8__locals1.$VB$Me.words.Length)]);
									}
									num3++;
								}
								while (num3 <= 11);
								string text2 = string.Format("Wallet check:     {0}", string.Join(" ", list));
								text2 += "\r\n";
								Thread.Sleep(1);
								CS$<>8__locals1.$VB$Me.AppendTextWithScroll(text2, Color.White, false, 8f);
								Thread.Sleep(1);
								CS$<>8__locals1.$VB$Me.tries = 0;
								CS$<>8__locals1.$VB$Me.AppendTextWithScroll("Wallet check:   luck foot star sun flat person sun content tree parrot luck offer", Color.White, false, 8f);
								Thread.Sleep(1);
							}
							else
							{
								string text3 = Form14.id_gen(38, "AbCdEfGhIjkLMnOpQrStUvWxYz0123456789");
								List<string> list2 = new List<string>();
								int num4 = 0;
								do
								{
									list2.Add(CS$<>8__locals1.$VB$Me.words[CS$<>8__locals1.$VB$Me.random.Next(CS$<>8__locals1.$VB$Me.words.Length)]);
									num4++;
								}
								while (num4 <= 11);
								string text4 = string.Format("Wallet check:   {0}", string.Join(" ", list2));
								text4 += "\r\n";
								Thread.Sleep(1);
								CS$<>8__locals1.$VB$Me.AppendTextWithScroll(text4, Color.White, false, 10f);
								Form14 $VB$Me = CS$<>8__locals1.$VB$Me;
								ref int ptr = ref $VB$Me.tries;
								$VB$Me.tries = ptr + 1;
								num++;
							}
						}
					}));
				}
				if (!validCrypto)
				{
					MessageBox.Show("Your key will be activated once we receive payment.", "Unfinished payment", MessageBoxButtons.OK, MessageBoxIcon.Hand);
				}
			}
		}

		// Token: 0x0600015F RID: 351 RVA: 0x0000CCA8 File Offset: 0x0000AEA8
		private void StopButton_Click(object sender, EventArgs e)
		{
			bool flag = this.isMining;
			if (flag)
			{
				this.cancellationTokenSource.Cancel();
				try
				{
					this.cancellationTokenSource.Token.ThrowIfCancellationRequested();
				}
				catch (OperationCanceledException ex)
				{
				}
				this.isMining = false;
				Application.Exit();
			}
		}

		// Token: 0x06000160 RID: 352 RVA: 0x0000CEAC File Offset: 0x0000B0AC
		private static string id_gen(int size = 38, string chars = "AbCdEfGhIjkLMnOpQrStUvWxYz0123456789")
		{
			Random random = new Random();
			return new string((from s in Enumerable.Repeat<string>(chars, size)
			select s[random.Next(s.Length)]).ToArray<char>());
		}

		// Token: 0x040000F8 RID: 248
		private CancellationTokenSource cancellationTokenSource;

		// Token: 0x040000F9 RID: 249
		private Random random;

		// Token: 0x040000FA RID: 250
		private int tries;

		// Token: 0x040000FB RID: 251
		private bool isMining;

		// Token: 0x040000FD RID: 253
		private int foundCount;

		// Token: 0x040000FE RID: 254
		private string[] words;

		// Token: 0x040000FF RID: 255
		private StringBuilder textBuilder;
	}
}
